***** Is Europe an optimal Political Area?                *****
***** Alberto Alesina, Guido Tabellini & Francesco Trebbi *****

***** Section III.A

*Set up 
clear all
set mem 10g
set matsize 11000
set more off

* Set output directory
cap mkdir "section3"
cap mkdir "appendix"


** Quality of Government
use "data/data_countries.dta", clear

global vars diat_ti icrg_qog vdem_corr 
keep country year $vars crgdppc rrgdppc WB_*
factor $vars , pcf factor(1) 
rotate, varimax
predict i_factor

factor WB_corruption WB_gov_effectiveness WB_pol_stability WB_reg_quality WB_rule_law WB_accountability , pcf factor(1) 
rotate, varimax
predict i_factorWB

collapse (mean) mvar = i_factor mvar_WB = i_factorWB (sd) sdvar = i_factor sdvar_WB = i_factorWB, by(country year)
bysort year: egen mmvar = mean(mvar)
bysort year: egen mmvar_WB = mean(mvar_WB)
bysort year: egen sdy_qog = sd(mvar) if country != "Luxembourg" & country != "Germany" 
bysort year: egen sdy_wb = sd(mvar_WB) if country != "Luxembourg" & country != "Germany" 

lab var mvar "QOG"
la var sdy_qog "Quality of Government"
la var sdy_wb "Governance (World Bank)"

* Figure 7a
twoway (line sdy_qog year) (line sdy_wb year, lp(dash) ), title("Sigma Convergence between countries") subtitle("Quality of Government") ///
        note("Note: standard deviation plotted over time. Germany and Luxembourg omitted")
graph export "section3/figure_7a.png", replace as(png)
***

* Figure A.10
twoway (line mvar year) (line mmvar year, lp("-")) if country !="Luxembourg" , ylab(-2(2)2) ymtick(-3 -1 1) by(country, iyl r(5) legend(off) iscale(1*) /*
*/ title("Quality of Government") subtitle("First Principal Component - Average by Country") note(""))
graph export "appendix/figure_A10a.png", replace as(png)

twoway (line mvar_WB year) (line mmvar_WB year, lp("-")) if country !="Luxembourg" ,by(country, iyl r(5) legend(off) iscale(1*) /*
*/ title("Governance (World Bank Indicators)") subtitle("First Principal Component - Average by Country") note(""))
graph export "appendix/figure_A10b.png", replace as(png)
***


** Legal institutions 
use "data/data_countries.dta", clear
keep if year>=1990 & year<2011
collapse (mean) mvar = legal_rel (sd) sdvar = legal_rel, by(country year)
bysort year: egen mmvar = mean(mvar)
bysort year: egen sdy_law = sd(mvar) if year > 1990
la var sdy_law "Quality of Legal Institutions (sd)"
  
* Figure 7b
twoway (line sdy_law year)  if sdy_law !=. , title("Sigma Convergence between countries") subtitle("Quality of Legal Institutions")
graph export   "section3/figure_7b.png", replace as(png)
***

* First A.11
twoway (line mvar year) (line mmvar year, lp("-")),by(country, iyl legend(off)  /*
*/ title("Quality of Legal Institutions") subtitle("Average by Country") note("")) 
graph export "appendix/figure_A11.png", replace as(png)
***


** Education 
use "data/data_countries.dta", clear
global vars math sci read
factor $vars, pcf factor(1) 
rotate, varimax
predict i_factor
collapse (mean) mvar = i_factor (sd) sdvar = i_factor, by(country year)

bysort year: egen mmvar = mean(mvar)
bysort year: egen sdy_education = sd(mvar) 
  
lab var mvar "Pisa Score"
lab var sdy_education "Pisa Score (sd)"

* Figure 7c
twoway (line sdy_education year)  if  sdy_education !=. , title("Sigma Convergence between countries") subtitle("PISA Score") ///
note("Note: All countries included. Data for UK is missing in 2003")
graph export "section3/figure_7c.png", replace as(png)
***

* Figure A.12
twoway (line mvar year) (line mmvar year, lp("-")),by(country, iyl legend(off) /*
*/ title("PISA Score") subtitle("First Principal Component - Average by Country") /*
*/ note("Note: All countries included. Data for UK is missing in 2003"))
graph export "appendix/figure_A12.png", replace as(png)
***


** Product Market Regulation
use "data/data_countries.dta", clear
keep if year>=1990 & year<2015
collapse (mean) mvar = pmr (sd) sdvar = pmr, by(country year)
bysort year: egen mmvar = mean(mvar)
bysort year: egen sdy_reg = sd(mvar)
la var sdy_reg "Product Market Regulation (sd)"
lab var mvar "Product Market Regulation"

* Figure 7d
twoway line sdy_reg year if sdy_reg !=. , title("Sigma Convergence between countries") subtitle("Product Market Regulation")
graph export "section3/figure_7d.png", replace as(png)
***

* Figure A.13
twoway (line mvar year) (line mmvar year, lp("-")) , by(country, iyl legend(off) /*
*/ title("Product Market Regulation") subtitle("Average by Country")/*
*/ note("Note: All countries included. Data for Luxembourg is missing in 1998"))
graph export "appendix/figure_A13.png", replace as(png)
***






